/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.entity.data;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import noppes.npcs.EventHooks;
import noppes.npcs.NBTTags;
import noppes.npcs.constants.EnumScriptType;
import noppes.npcs.controllers.IScriptHandler;
import noppes.npcs.controllers.ScriptContainer;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.entity.EntityNPCInterface;

public class DataScript
implements IScriptHandler {
    private boolean enabled = false;
    public long lastInited = -1L;
    public EntityNPCInterface npc;
    private String scriptLanguage = "ECMAScript";
    private List<ScriptContainer> scripts = new ArrayList<ScriptContainer>();

    public DataScript(EntityNPCInterface npc) {
        this.npc = npc;
    }

    @Override
    public void clearConsole() {
        for (ScriptContainer script : this.getScripts()) {
            script.console.clear();
        }
    }

    @Override
    public TreeMap<Long, String> getConsoleText() {
        TreeMap<Long, String> map = new TreeMap<Long, String>();
        int tab = 0;
        for (ScriptContainer script : this.getScripts()) {
            ++tab;
            for (Map.Entry<Long, String> entry : script.console.entrySet()) {
                String log = map.containsKey(entry.getKey()) ? map.get(entry.getKey()) + "\n\nScriptTab " + tab + ":\n" + entry.getValue() : " ScriptTab " + tab + ":\n" + entry.getValue();
                map.put(entry.getKey(), log);
            }
        }
        return map;
    }

    @Override
    public void clearConsoleText(Long key) {
        for (ScriptContainer script : this.getScripts()) {
            script.console.remove(key);
        }
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public String getLanguage() {
        return this.scriptLanguage;
    }

    @Override
    public List<ScriptContainer> getScripts() {
        return this.scripts;
    }

    @Override
    public boolean isClient() {
        return Thread.currentThread().getName().toLowerCase().contains("client");
    }

    public boolean isEnabled() {
        return this.enabled && ScriptController.HasStart && !this.scripts.isEmpty();
    }

    @Override
    public ITextComponent noticeString(String type, Object event) {
        TextComponentString message = new TextComponentString("");
        message.func_150256_b().func_150238_a(TextFormatting.DARK_GRAY);
        if (type != null) {
            TextComponentString hook = new TextComponentString("Hook \"");
            hook.func_150256_b().func_150238_a(TextFormatting.DARK_GRAY);
            TextComponentString hookType = new TextComponentString(type);
            hookType.func_150256_b().func_150238_a(TextFormatting.GRAY);
            TextComponentString hookEnd = new TextComponentString("\"; ");
            hookEnd.func_150256_b().func_150238_a(TextFormatting.DARK_GRAY);
            message = message.func_150257_a((ITextComponent)hook).func_150257_a((ITextComponent)hookType).func_150257_a((ITextComponent)hookEnd);
        }
        TextComponentString mesNpc = new TextComponentString("NPC \"");
        mesNpc.func_150256_b().func_150238_a(TextFormatting.DARK_GRAY);
        TextComponentString name = new TextComponentString(this.npc.func_70005_c_());
        name.func_150256_b().func_150238_a(TextFormatting.GRAY);
        TextComponentString mesUUID = new TextComponentString("\"; UUID: \"");
        mesUUID.func_150256_b().func_150238_a(TextFormatting.DARK_GRAY);
        TextComponentString uuid = new TextComponentString(this.npc.func_110124_au().toString());
        uuid.func_150256_b().func_150238_a(TextFormatting.GRAY);
        TextComponentString mesEnd = new TextComponentString("\" in ");
        mesEnd.func_150256_b().func_150238_a(TextFormatting.DARK_GRAY);
        message = message.func_150257_a((ITextComponent)mesNpc).func_150257_a((ITextComponent)name).func_150257_a((ITextComponent)mesUUID).func_150257_a((ITextComponent)uuid).func_150257_a((ITextComponent)mesEnd);
        int dimID = this.npc.field_70170_p == null ? 0 : this.npc.field_70170_p.field_73011_w.getDimension();
        double x = (double)Math.round(this.npc.field_70165_t * 100.0) / 100.0;
        double y = (double)Math.round(this.npc.field_70163_u * 100.0) / 100.0;
        double z = (double)Math.round(this.npc.field_70161_v * 100.0) / 100.0;
        TextComponentString posClick = new TextComponentString("dimension ID:" + dimID + "; X:" + x + "; Y:" + y + "; Z:" + z);
        posClick.func_150256_b().func_150238_a(TextFormatting.BLUE).func_150228_d(Boolean.valueOf(true)).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/noppes world tp @p " + dimID + " " + x + " " + y + " " + z)).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentTranslation("script.hover.error.pos.tp", new Object[0])));
        TextComponentString side = new TextComponentString("; Side: " + (this.isClient() ? "Client" : "Server"));
        side.func_150256_b().func_150238_a(TextFormatting.DARK_GRAY);
        return message.func_150257_a((ITextComponent)posClick).func_150257_a((ITextComponent)side);
    }

    public void readFromNBT(NBTTagCompound compound) {
        this.scripts = NBTTags.GetScript(compound.func_150295_c("Scripts", 10), this, false);
        this.scriptLanguage = compound.func_74779_i("ScriptLanguage");
        this.enabled = compound.func_74767_n("ScriptEnabled");
    }

    @Override
    public void runScript(String type, Event event) {
        if (!this.isEnabled()) {
            return;
        }
        if (ScriptController.Instance.lastLoaded > this.lastInited) {
            this.lastInited = ScriptController.Instance.lastLoaded;
            if (!type.equalsIgnoreCase(EnumScriptType.INIT.function)) {
                EventHooks.onNPCInit(this.npc);
            }
        }
        for (ScriptContainer script : this.scripts) {
            script.run(type, event);
        }
    }

    @Override
    public void setEnabled(boolean bo) {
        this.enabled = bo;
    }

    @Override
    public void setLanguage(String lang) {
        this.scriptLanguage = lang;
    }

    @Override
    public void setLastInited(long timeMC) {
        this.lastInited = timeMC;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        compound.func_74782_a("Scripts", (NBTBase)NBTTags.NBTScript(this.scripts));
        compound.func_74778_a("ScriptLanguage", this.scriptLanguage);
        compound.func_74757_a("ScriptEnabled", this.enabled);
        return compound;
    }
}

